<?php

namespace App\Http\Requests\Client;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
  /*  public function messages():array
    {
        return [
            'name.required' => 'El :attribute es obligatorio.',
            'price.required' => 'Añade un :attribute al producto',
            'price.min' => 'El :attribute debe ser mínimo 0'
        ];
    }*/
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'identification'=>'required|unique:clients|max:50',
            'name_last_name'=>'required|max:100',            
            'address'=>'required|max:100',                          
            'email'=>'required|email|max:50',
            'birth_date'=>'required',
            'expedition_date'=>'required',
            'neighborhood'=>'required|max:50',
            'marital_status' => 'required',
            'study_level' =>'required',          //
        ];
    }
    public function messages()
    {
        return [
            'identification.required' => 'La :attribute es obligatoria.',
            'identification.unique' => 'La :attribute ya está registrada.',
            'identification.max' => 'La :attribute no debe ser mayor a 50 caracteres.',
            'name_last_name.required' => 'El :attribute es obligatorio.',
            'name_last_name.max' => 'El :attribute no debe ser mayor a 100 caracteres.',            
            'address.required' => 'La :attribute es obligatoria.',
            'address.max' => 'La :attribute no debe ser mayor a 100 caracteres.',                          
            'email.required' => 'El :attribute es obligatorio.',
            'email.email' => 'El :attribute debe ser una dirección de correo válida.',
            'email.max' => 'El :attribute no debe ser mayor a 50 caracteres.',
            'birth_date.required' => 'La :attribute es obligatoria.',
            'expedition_date.required' => 'La :attribute es obligatoria.',
            'neighborhood.required' => 'El :attribute es obligatorio.',
            'neighborhood.max' => 'El :attribute no debe ser mayor a 50 caracteres.',
            'marital_status.required' => 'El :attribute es obligatorio.',
            'study_level.required' => 'El :attribute es obligatorio.',           
        ];    
    }
    public function attributes()
    {
        return [
            'identification' => 'identificación',
            'name_last_name' => 'nombre y apellido',            
            'address' => 'dirección',                          
            'email' => 'correo electrónico',
            'birth_date' => 'fecha de nacimiento',
            'expedition_date' => 'fecha de expedición',
            'neighborhood' => 'barrio',
            'marital_status' => 'estado civil',
            'study_level' => 'nivel de estudios',          
        ];
    }
}
